<#-- [To be added in the future] ftl output_format="XML" -->
<?xml version="1.0" encoding="utf-8"?>
<#if .version??>
    ${logger.log("INFO - FreeMarker version " + .version)}
</#if>
<#function bts b>
    <#if b>
        <#return "true">
    <#else>
        <#return "false">
    </#if>
</#function>
<config>
    <checkupdates>false</checkupdates>
    <presencednd>true</presencednd>
    <proxylocktransport>true</proxylocktransport>
    <phonemessaging>none</phonemessaging>
    <keypadletters>false</keypadletters>
    <interceptringing>true</interceptringing>
    <disablebsimport>true</disablebsimport>

    <onstart>${profile.onstart?trim?html}</onstart>
    <onexit>${profile.onexit?trim?html}</onexit>
<#if profile.websettings != "no">
    <#if profile.websettings == "other">
    <websettings>${profile.websettingsurl?html}</websettings>
    <#else>
        <#-- 2.06+ -->
        <#if userData.commportalURL??>
            <#if userData.commportalURL?starts_with("http")>
                <#if profile.websettings == "cplogged" && userData.commportalPAT??>
    <websettingstitle>CommPortal</websettingstitle>
    <websettings>${userData.commportalURL?html}login?${userData.commportalPAT?html}&amp;version=9.1&amp;redirectTo=%2Fline%2Fmain.html&amp;errorRedirectTo=%2Flogin.html</websettings>
                <#elseif profile.websettings == "acdagentlogged" && userData.commportalPAT??>
    <websettingstitle>ACD Agent</websettingstitle>
    <websettings>${userData.commportalURL?html}login?${userData.commportalPAT?html}&amp;version=9.1&amp;redirectTo=%2Fline%2Fagentstats.html&amp;errorRedirectTo=%2Flogin.html</websettings>
                <#elseif profile.websettings == "acdgrouplogged" && userData.commportalPAT??>
    <websettingstitle>ACD Group</websettingstitle>
    <websettings>${userData.commportalURL?html}login?${userData.commportalPAT?html}&amp;version=9.1&amp;redirectTo=%2Fbg%2Fdepartment%2Facdstats.html&amp;errorRedirectTo=%2Flogin.html</websettings>
                <#else>
    <websettingstitle>CommPortal</websettingstitle>
    <websettings>${userData.commportalURL?html}</websettings>
                </#if>
            <#else>
                ${logger.log("WARNING - Online settings - Invalid userData.commportalURL: " + userData.commportalURL)}
            </#if>
        <#else>
            ${logger.log("WARNING - Online settings - userData.commportalURL not available (PS 2.06+ required)")}
        </#if>
    </#if>
</#if>

    <display>${userData.displayName?html}</display>
    <username>${userData.sipUsername?html}</username>
    <proxyhost>${userData.sipDomainName?html}</proxyhost>
    <proxyusername>${userData.sipAuthID?html}</proxyusername>
    <proxypassword>${userData.sipPassword?html}</proxypassword>

    <voicemail>${profile.voicemail}</voicemail>
    <subscribevoicemail>${bts(profile.subscribevoicemail)}</subscribevoicemail>

    <proxyaddress>${profile.proxyaddress?trim?html}</proxyaddress>
<#if profile.proxyport?is_number>
    <proxyport>${profile.proxyport}</proxyport>
</#if>
    <proxydnssrv>${bts(profile.proxydnssrv)}</proxydnssrv>
    <proxytransport>${profile.proxytransport}</proxytransport>
    <proxydnsnaptr>${bts(profile.proxydnsnaptr)}</proxydnsnaptr>
<#if profile.proxyexpires?is_number>
    <proxyexpires>${profile.proxyexpires}</proxyexpires>
</#if>
<#if profile.proxyping?is_number>
    <proxyping>${profile.proxyping}</proxyping>
</#if>
    <presencedetails>${bts(profile.presencedetails)}</presencedetails>
    <intercept>${profile.intercept?trim?html}</intercept>

<#if profile.operator != "">
    <operator>${profile.operator}</operator>
    <bridge>${bts(profile.bridge)}</bridge>
    <operatorfeedback>${profile.operatorfeedback}</operatorfeedback>
    <autocalloperator>${bts(profile.autocalloperator)}</autocalloperator>
    <#if profile.autohangupoperator?is_number>
    <autohangupoperator>${profile.autohangupoperator}</autohangupoperator>
    </#if>
    <hangupoperatorcall>${bts(profile.hangupoperatorcall)}</hangupoperatorcall>
    <incallringing>${bts(profile.incallringing)}</incallringing>
    <playtones>${bts(profile.playtones)}</playtones>
    <operatorintercom>${bts(profile.operatorintercom)}</operatorintercom>
</#if>

<#if profile.usbheadset != "user">
    <usbheadset>${profile.usbheadset}</usbheadset>
</#if>
<#if profile.usblight != "user">
    <usblight>${profile.usblight}</usblight>
</#if>
<#if profile.usbmode != "user">
    <usbmode>${profile.usbmode}</usbmode>
</#if>
    <usbpid>${profile.usbpid?trim?html}</usbpid>

<#if profile.maxtotalcalls?is_number>
    <maxtotalcalls>${profile.maxtotalcalls}</maxtotalcalls>
</#if>
    <showfromto>${bts(profile.showfromto)}</showfromto>
    <callduration>${bts(profile.callduration)}</callduration>
    <onholdduration>${bts(profile.onholdduration)}</onholdduration>
    <onholdwarntime>${profile.onholdwarntime}</onholdwarntime>
    <showlocalcalls>${bts(profile.showlocalcalls)}</showlocalcalls>
    <calllogelsewhere>${bts(profile.calllogelsewhere)}</calllogelsewhere>
<#if profile.calllogmax?is_number>
    <calllogmax>${profile.calllogmax}</calllogmax>
</#if>
<#if profile.configuretones == "yes">
    <tonedial>${profile.tonedial?trim?html}</tonedial>
    <toneringback>${profile.toneringback?trim?html}</toneringback>
    <tonebusy>${profile.tonebusy?trim?html}</tonebusy>
    <toneringing>${profile.toneringing?trim?html}</toneringing>
</#if>

    <searchfromfield>${bts(profile.searchfromfield)}</searchfromfield>
    <searchtofield>${bts(profile.searchtofield)}</searchtofield>
    <alertpriority>${profile.alertpriority?trim?html}</alertpriority>
    <restrictcalls>${bts(profile.restrictcalls)}</restrictcalls>

<#if profile.maxoutgoingcalls?is_number>
    <maxoutgoingcalls>${profile.maxoutgoingcalls}</maxoutgoingcalls>
</#if>
    <calllogoutgoing>${bts(profile.calllogoutgoing)}</calllogoutgoing>
    <disableintercom>${bts(profile.disableintercom)}</disableintercom>
    <alertintercom>${profile.alertintercom?trim?html}</alertintercom>

    <queueblindtransfer>${bts(profile.queueblindtransfer)}</queueblindtransfer>
    <queuetransferdelay>${profile.queuetransferdelay}</queuetransferdelay>
    <referdisconnect>${bts(profile.referdisconnect)}</referdisconnect>

    <recordcodec>${profile.recordcodec}</recordcodec>
    <recordsingle>${bts(profile.recordsingle)}</recordsingle>

    <crm>${profile.crm?trim?html}</crm>
    <crmmethod>${profile.crmmethod}</crmmethod>
    <crmwindow>${bts(profile.crmwindow)}</crmwindow>
    <crmanonymous>${bts(profile.crmanonymous)}</crmanonymous>
    <crminternal>${bts(profile.crminternal)}</crminternal>
    <crmoutgoing>${bts(profile.crmoutgoing)}</crmoutgoing>
    <crmdoubleclick>${bts(profile.crmdoubleclick)}</crmdoubleclick>
    <crmpickup>${bts(profile.crmpickup)}</crmpickup>
    <crmringing>${bts(profile.crmringing)}</crmringing>
    <crmrejected>${bts(profile.crmrejected)}</crmrejected>
    <crmonstart>${bts(profile.crmrejected)}</crmonstart>

    <dragndrop>${bts(profile.dragndrop)}</dragndrop>
    <samegroupdrop>${bts(profile.samegroupdrop)}</samegroupdrop>

    <hotkeycall>${bts(profile.hotkeycall)}</hotkeycall>
<#if profile.hotkeycallprefixtype == "externallinecode">
    <hotkeycallprefix>${userData.externalLineCode}</hotkeycallprefix>
<#elseif profile.hotkeycallprefixtype != "none">
    <hotkeycallprefix>${profile.hotkeycallprefix}</hotkeycallprefix>
</#if>
    <keyeditcaller>${profile.keyeditcaller?trim?html}</keyeditcaller>
    <keyedit>${profile.keyedit?trim?html}</keyedit>
    <keysearch>${profile.keysearch?trim?html}</keysearch>
    <keydial>${profile.keydial?trim?html}</keydial>
    <keycrm>${profile.keycrm?trim?html}</keycrm>
    <keyweb>${profile.keyweb?trim?html}</keyweb>
    <keyemail>${profile.keyemail?trim?html}</keyemail>
    <keynote>${profile.keynote?trim?html}</keynote>
    <keykeypad>${profile.keykeypad?trim?html}</keykeypad>
    <keyactivate>${profile.keyactivate?trim?html}</keyactivate>
    <keyhangup>${profile.keyhangup?trim?html}</keyhangup>
    <keytransfer>${profile.keytransfer?trim?html}</keytransfer>
    <keyswitch>${profile.keyswitch?trim?html}</keyswitch>

<#assign logo = profile.logo?trim?lower_case>
<#if logo != "" && logo != "none">
    <logo>${profile.logo?trim?html}</logo>
</#if>
    <theme>${profile.theme}</theme>
<#if profile.fonttype?trim != "">
    <fonttype>${profile.fonttype?trim?html}</fonttype>
</#if>
<#if profile.fontsize?is_number>
    <fontsize>${profile.fontsize}</fontsize>
</#if>
    <calllayout>${profile.calllayout}</calllayout>
    <directorylayout>${profile.directorylayout}</directorylayout>
    <directoryallowdup>${bts(profile.directoryallowdup)}</directoryallowdup>
    <userpresenceicon>${bts(profile.userpresenceicon)}</userpresenceicon>
    <userpresencebold>${bts(profile.userpresencebold)}</userpresencebold>
    <directorysearch>${profile.directorysearch}</directorysearch>
    <locklayout>${bts(profile.locklayout)}</locklayout>
    <savestate>${bts(profile.savestate)}</savestate>
<#if profile.configurewindow == "yes">
    <windowarea>${profile.windowarea}</windowarea>
    <windowfeatures>${profile.windowfeatures}</windowfeatures>
    <#if profile.statusbaritems == "">
    <statusbar>false</statusbar>
    </#if>
    <statusbaritems>${profile.statusbaritems?replace(",","")}</statusbaritems>
    <#if profile.alwaysontop == true>
    <alwaysontop>true</alwaysontop>
    </#if>
    <showintaskbar>${bts(profile.showintaskbar)}</showintaskbar>
    <trayicon>${bts(profile.trayicon)}</trayicon>
    <menuonselect>${profile.menuonselect}</menuonselect>
</#if>

<#if profile.language != "user" && profile.language != "autodetect">
    <language>${profile.language}</language>
</#if>
<#if profile.internationalprefix != "">
    <internationalprefix>${profile.internationalprefix}</internationalprefix>
</#if>
<#if profile.localprefix != "">
    <localprefix>${profile.localprefix}</localprefix>
</#if>
<#if profile.countrycode != "">
    <countrycode>${profile.countrycode}</countrycode>
</#if>

    <mailinternal>${bts(profile.mailinternal)}</mailinternal>
    <mailoffice365>${bts(profile.mailoffice365)}</mailoffice365>
    <mailserver>${profile.mailserver?trim?html}</mailserver>
    <mailusername>${profile.mailusername?trim?html}</mailusername>
    <mailpassword>${profile.mailpassword?trim?html}</mailpassword>
    <mailssl>${bts(profile.mailssl)}</mailssl>
    <mailfrom>${profile.mailfrom?trim?html}</mailfrom>
    <mailbcc>${profile.mailbcc?trim?html}</mailbcc>
    <mailsubject>${profile.mailsubject?trim?html}</mailsubject>
    <mailtemplate>${profile.mailtemplate?trim?html}</mailtemplate>

    <webinternal>${bts(profile.webinternal)}</webinternal>
    <webtitle>${profile.webtitle?trim?html}</webtitle>
    <webhome>${profile.webhome?trim?html}</webhome>
<#if profile.webcompatibility != "autodetect">
    <webcompatibility>${profile.webcompatibility}</webcompatibility>
</#if>
<#if profile.calltoprefixtype == "externallinecode">
    <calltoprefix>${userData.externalLineCode}</calltoprefix>
<#elseif profile.calltoprefixtype != "none">
    <calltoprefix>${profile.calltoprefix}</calltoprefix>
</#if>
    
    <ldapserver>${profile.ldapserver?trim?html}</ldapserver>
    <ldapauth>${profile.ldapauth}</ldapauth>
    <ldapusername>${profile.ldapusername?trim?html}</ldapusername>
    <ldappassword>${profile.ldappassword?trim?html}</ldappassword>
    <ldapusers>${profile.ldapusers?trim?html}</ldapusers>
    <ldapcontacts>${profile.ldapcontacts?trim?html}</ldapcontacts>
    <ldappicture>${profile.ldappicture?trim?html}</ldappicture>
    <ldapnote>${profile.ldapnote?trim?html}</ldapnote>
    <ldaplocalphone>${profile.ldaplocalphone?trim?html}</ldaplocalphone>
    <ldappresence>${profile.ldappresence?trim?html}</ldappresence>
    <ldapuserspresence>${bts(profile.ldapuserspresence)}</ldapuserspresence>
<#if profile.ldapphoneprefixtype == "externallinecode">
    <ldapphoneprefix>${userData.externalLineCode}</ldapphoneprefix>
<#elseif profile.ldapphoneprefixtype != "none">
    <ldapphoneprefix>${profile.ldapphoneprefix}</ldapphoneprefix>
</#if>
    <ldapvoicemailprefix>${profile.ldapvoicemailprefix?trim?html}</ldapvoicemailprefix>
    <ldapxmpp>${profile.ldapxmpp?trim?html}</ldapxmpp>
    <ldapcalendar>${profile.ldapcalendar?trim?html}</ldapcalendar>
    <ldapondemand>${bts(profile.ldapondemand)}</ldapondemand>
<#if profile.ldapmaxusers?is_number>
    <ldapmaxusers>${profile.ldapmaxusers}</ldapmaxusers>
</#if>
    <ldaptimeout>${profile.ldaptimeout}</ldaptimeout>
    <ldappagesize>${profile.ldappagesize}</ldappagesize>

<#if profile.office365 == "yes">
    <office365>true</office365>
<#else>
    <office365>false</office365>
</#if>
 
<#if profile.outlookcontacts != "user">
    <#if profile.outlookcontacts == "yes">
    <outlookcontacts>true</outlookcontacts>
    <#else>
    <outlookcontacts>false</outlookcontacts>
    </#if>
</#if>
    <outlooksynconstart>${bts(profile.outlooksynconstart)}</outlooksynconstart>
    <outlookfolder>${profile.outlookfolder?trim?html}</outlookfolder>
    <outlookpictures>${bts(profile.outlookpictures)}</outlookpictures>
    <outlookemails>${bts(profile.outlookemails)}</outlookemails>
<#if profile.outlookphoneprefixtype == "externallinecode">
    <outlookphoneprefix>${userData.externalLineCode}</outlookphoneprefix>
<#elseif profile.outlookphoneprefixtype != "none">
    <outlookphoneprefix>${profile.outlookphoneprefix}</outlookphoneprefix>
</#if>
    
    <xmpphost>${profile.xmpphost?trim?html}</xmpphost>
    <xmppaddress>${profile.xmppaddress?trim?html}</xmppaddress>
<#if profile.xmppport?is_number>
    <xmppport>${profile.xmppport}</xmppport>
</#if>
    <xmppdnssrv>${bts(profile.xmppdnssrv)}</xmppdnssrv>
<#if profile.xmpphost?trim != "" && profile.xmppaccount == "ams">
    <xmppusername>$[vop.username]</xmppusername>
    <xmpppassword>$[vop.password]</xmpppassword>
<#elseif profile.xmppaccount == "below">
    <xmppusername>${profile.xmppusername?trim?html}</xmppusername>
    <xmpppassword>${profile.xmpppassword?trim?html}</xmpppassword>
</#if>
    <xmppresource>${profile.xmppresource?trim?html}</xmppresource>
    <xmpptls>${bts(profile.xmpptls)}</xmpptls>
    <xmppkeepalive>${bts(profile.xmppkeepalive)}</xmppkeepalive>
    <xmpprejectsub>${profile.xmpprejectsub}</xmpprejectsub>
    <xmppchatstate>${profile.xmppchatstate}</xmppchatstate>
    <xmppphonestatus>${bts(profile.xmppphonestatus)}</xmppphonestatus>
    <xmppphonenote>${profile.xmppphonenote?trim?html}</xmppphonenote>
    <xmppmanagecontacts>${bts(profile.xmppmanagecontacts)}</xmppmanagecontacts>
    <xmppimportpicture>${bts(profile.xmppimportpicture)}</xmppimportpicture>
    <xmppimportinfo>${bts(profile.xmppimportinfo)}</xmppimportinfo>
    <xmppfiletransfer>${bts(profile.xmppfiletransfer)}</xmppfiletransfer>

<#if profile.localip?trim != "">
    <localip>${profile.localip?trim?html}</localip>
</#if>
<#if profile.localport?is_number>
    <localport>${profile.localport}</localport>
</#if>
    <externalip>${profile.externalip?trim?html}</externalip>
<#if profile.externalport?is_number>
    <externalport>${profile.externalport}</externalport>
</#if>
    <symmetricsip>${bts(profile.symmetricsip)}</symmetricsip>
<#if profile.rtpportrangestart?is_number && profile.rtpportrangeend?is_number>
    <rtpportrange>${profile.rtpportrangestart}-${profile.rtpportrangeend}</rtpportrange>
</#if>
    <symmetricrtp>${bts(profile.symmetricrtp)}</symmetricrtp>
    <securertp>${profile.securertp}</securertp>
    <preferredcodec>${profile.preferredcodec}</preferredcodec>
    <forcedcodec>${profile.forcedcodec}</forcedcodec>
    <dtmfoutband>${bts(profile.dtmfoutband)}</dtmfoutband>
    <dtmfpayload>${profile.dtmfpayload}</dtmfpayload>
    <dtmfduration>${profile.dtmfduration}</dtmfduration>
    <dtmfdelay>${profile.dtmfdelay}</dtmfdelay>
    <rtppackettime>${profile.rtppackettime}</rtppackettime>
    <rtpqueuetime>${profile.rtpqueuetime}</rtpqueuetime>
    <compactheaders>${bts(profile.compactheaders)}</compactheaders>
    <subscriptiondelay>${profile.subscriptiondelay}</subscriptiondelay>
    <tlscertificate>${profile.tlscertificate?trim?html}</tlscertificate>
    <siptlsversion>${profile.siptlsversion?trim?html}</siptlsversion>
    <xmpptlsversion>${profile.xmpptlsversion?trim?html}</xmpptlsversion>
    <httptlsversion>${profile.httptlsversion?trim?html}</httptlsversion>
        
    <samplingrate>${profile.samplingrate}</samplingrate>
    <dxfullduplex>${bts(profile.dxfullduplex)}</dxfullduplex>
    <noisereduction>${bts(profile.noisereduction)}</noisereduction>
    <echocanceller>${bts(profile.echocanceller)}</echocanceller>

    <disableeffects>${bts(profile.disableeffects)}</disableeffects>
    <disablerecording>${bts(profile.disablerecording)}</disablerecording>
    <disableg722>${bts(profile.disableg722)}</disableg722>
    <disableg729>${bts(profile.disableg729)}</disableg729>
    
    <showdebug>${bts(profile.showdebug)}</showdebug>
    <debuglevel>${profile.debuglevel}</debuglevel>
    <syslogserver>${profile.syslogserver?trim?html}</syslogserver>
    <syslogfacility>${profile.syslogfacility?trim?html}</syslogfacility>
    
    <license>${profile.license}</license>
    <version>${profile.version}</version>
    
    <settings>
        <header>EN:Softphone|FR:Softphone|ES:Softphone|DE:Softphone|IT:Softphone|NL:Softphone|DA:Softphone|PT:Softphone|PL:Softphone|TR:Yazılım telefon|RU:Софтфон</header>
        <inputdevice/>
        <outputdevice/>
        <speakerdevice/>
        <header>USB</header>
<#if profile.usbheadset == "user">
        <usbheadset/>
</#if>
<#if profile.usblight == "user">
        <usblight/>
</#if>
<#if profile.usbmode == "user">
        <usbmode/>
</#if>
        <usbbrightness/>
        <usbvolume/>
        <usbexclusive/>
<#if profile.soundmoh>
        <header>EN:Global Calls|FR:Appels|ES:Llamadas Globales|DE:Anrufe global|IT:Chiamate globali|NL:Globale Oproepen|DA:Globale kald|PT:Chamadas Globais|PL:Połączenia na całym świecie|TR:Tüm aramalar|RU:Глобальные звонки</header>
        <soundmoh/>
</#if>
        <header>EN:Incoming Calls|FR:Appels Entrants|ES:Llamadas Entrantes|DE:Eingehende Anrufe|IT:Chiamate in ingresso|NL:Inkomende Oproepen|DA:Indgående kald|PT:Chamadas a Receber|PL:Połączenia przychodzące|TR:Gelen aramalar|RU:Входящие вызовы</header>
        <rejectcalls/>
        <showrejectedcalls/>
        <bringtofront/>
        <autopickup/>
        <playringing/>
        <incallringing/>
        <soundringing/>
        <incallringingtone/>
        <ringingtonevolume/>
        <ringingrepeat/>
        <autohold/>
        <autoforward/>
        <maxincomingcalls/>
        <forwardingtarget/>
        <blacklist/>
<#if profile.disablerecording == false>
        <header>EN:Recording|FR:Enregistrement|ES:Grabación|DE:Aufnahme|IT:Registrazione|NL:Opname|DA:Optagelse|PT:Gravação|PL:Nagranie|TR:Kayıt|RU:Запись</header>
        <recordingsfolder/>
</#if>
        <header>EN:Appearance|FR:Apparence|ES:Apariencia|DE:Oberfläche|IT:Aspetto|NL:Uiterlijk|DA:Udseende|PT:Aparência|PL:Powierzchnia|TR:Görünüm|RU:Внешность</header>
<#if profile.fonttype?trim == "">
        <fonttype/>
</#if>
<#if !profile.fontsize?is_number>
        <fontsize/>
</#if>
<#if profile.alwaysontop == false>
        <alwaysontop/>
</#if>
<#if profile.language == "user">
        <header>EN:Localization|FR:Localisation|ES:Localización|DE:Lokalisierung|IT:Localizzazione|NL:Taal|DA:Lokale indstillinger|PT:Opções Regionais|PL:Lokalizacja|TR:Yerelleştirme|RU:Локализация</header>
        <language/>
</#if>
        <header>EN:Other|FR:Autres|ES:Otro|DE:Sonstiges|IT:Altro|NL:Overige|DA:Andet|PT:Outros|PL:Inne|TR:Diğer|RU:Другой</header>
        <autoaway/>
        <playmsgreceived/>
        <soundmsgreceived/>
        <minimizenewmsg/>
        <desktopalerts/>
        <alertduration/>
        <soundalert/>
        <confirmexit/>
        <runatstartup/>
<#if profile.office365 != "never">
        <header>Office365</header>
        <office365/>
</#if>
<#if profile.outlookcontacts == "user">
        <header>Outlook</header>
        <outlookcontacts/>
</#if>
<#if profile.xmppaccount == "user">
        <header>XMPP - AMS</header>
        <xmppusername/>
        <xmpppassword/>
</#if>
<#if profile.localip?trim == "">
        <header>EN:Network|FR:Réseau|ES:Red|DE:Netzwerk|IT:Rete|NL:Netwerk|DA:Netværk|PT:Rede|PL:Sieć|TR:Ağ|RU:Сеть</header>
        <localip/>
</#if>
    </settings>

<#list 0..11 as idx>
 <#if profile.directoryprefixtype[idx] == "externallinecode">
    <#assign prefix = userData.externalLineCode>
 <#elseif profile.directoryprefixtype[idx] == "other">
    <#assign prefix = profile.directoryprefix[idx]>
 <#else>
    <#assign prefix = "">
 </#if>
 <#if profile.directoryname[idx] != "" && profile.directoryphonetype[idx] == "contacts">
    <#-- 2.06+ -->
    <#if userData.commportalURL?? && userData.commportalPAT??>
        <#if userData.commportalURL?starts_with("http")>
    <mcpdirectory>${profile.directoryname[idx]?trim?html},${userData.commportalURL?html},${userData.directoryNumber},${userData.commportalPAT?html},contacts,,,${prefix},false,${profile.directorydefaultlayout[idx]}</mcpdirectory>
        <#else>
            ${logger.log("WARNING - Contacts directory - Invalid userData.commportalURL: " + userData.commportalURL)}
        </#if>
    <#else>
        ${logger.log("WARNING - Contacts directory - userData.commportalURL/PAT not available (PS 2.06+ required)")}
    </#if>
 <#elseif profile.directoryname[idx] != "">
    <#-- 2.06+ -->
    <#if profile.directoryphonetype[idx] == "parkingorbits">
        <#if userData.parkOrbits??>
    <directory>
        <local>true</local>
        <name>${profile.directoryname[idx]?trim?html}</name>
        <phone>${profile.directoryphone[idx]?trim?html}</phone>
        <greeting>${profile.directorygreeting[idx]?trim?html}</greeting>
        <layout>${profile.directorydefaultlayout[idx]}</layout>
            <#list userData.parkOrbits?keys as number>
                <#if userData.parkOrbits[number].departmentFull != "None">
                    <#assign name = "${number} ${userData.parkOrbits[number].departmentFull}">
                <#else>
                    <#assign name = number>
                </#if>
                <#if number == "" || !number?matches("[0-9]*") || ((!profile.directoryrangestart[idx]?is_number || number?number gte profile.directoryrangestart[idx]) && (!profile.directoryrangeend[idx]?is_number || number?number lte profile.directoryrangeend[idx])) >
        <user>
            <name>${name?html}</name>
            <picture>@parking</picture>
                <#if profile.directoryalert[idx] != "">
            <alert>${profile.directoryalert[idx]}</alert>
                </#if>
            <contact>
                <presence>${bts(profile.directorypresence[idx])}</presence>
                <type>phone</type>
                <uri>${prefix}${number}</uri>
            </contact>
        </user>
                </#if>
            </#list>
    </directory>
        <#else>
            ${logger.log("WARNING - Parking orbits directory - userData.parkOrbits not available (PS 2.06+ required)")}
        </#if>
    <#else>
    <directory>
        <local>true</local>
        <name>${profile.directoryname[idx]?trim?html}</name>
        <phone>${profile.directoryphone[idx]?trim?html}</phone>
        <greeting>${profile.directorygreeting[idx]?trim?html}</greeting>
        <layout>${profile.directorydefaultlayout[idx]}</layout>
        <#list userData.contacts as contact>
            <#if profile.directoryphonetype[idx] == "lines">
                <#assign number = contact.directoryNumber>
            <#else>
                <#assign number = contact.extension>
            </#if>
            <#if number == "" || !number?matches("[0-9]*") || ((!profile.directoryrangestart[idx]?is_number || number?number gte profile.directoryrangestart[idx]) && (!profile.directoryrangeend[idx]?is_number || number?number lte profile.directoryrangeend[idx])) >
        <user>
                <#if contact.name?trim != "">
            <name>${contact.name?trim?html}</name>
                <#else>
            <name>${number}</name>
                </#if>
                <#if profile.directoryalert[idx] != "">
            <alert>${profile.directoryalert[idx]}</alert>
                </#if>
            <contact>
                <default>true</default>
                <presence>${bts(profile.directorypresence[idx])}</presence>
                <type>phone</type>
                <uri>${prefix}${number}</uri>
            </contact>
                <#if profile.directoryvoicemailprefix[idx] != "">
            <contact>
                <presence>false</presence>
                <type>voicemail</type>
                <uri>${profile.directoryvoicemailprefix[idx]}${number}</uri>
            </contact>
                </#if>
                <#if profile.xmpphost?trim != "" && profile.directoryxmpp[idx]>
            <contact>
                <type>xmpp</type>
                <uri>${contact.directoryNumber}@${profile.xmpphost?trim?html}</uri>
            </contact>
                </#if>
        </user>
            </#if>
        </#list>
    </directory>
    </#if>
 </#if>
</#list>

</config>
